
    // ... (весь ваш JavaScript код залишається тут) ...
document.addEventListener('DOMContentLoaded', () => {
    // Функції запису аудіо
    let currentRecorder = null;
    let currentStream = null;
    let currentChunks = [];
    let currentId = null;
    let currentText = null;

    window.startRecording = async (id, text) => {
        if (currentRecorder) {
            console.log('⚠️ Запис вже виконується.');
            return;
        }
        try {
            const stream = await navigator.mediaDevices.getUserMedia({ audio: true });
            const mediaRecorder = new MediaRecorder(stream);
            const audioChunks = [];

            currentRecorder = mediaRecorder;
            currentStream = stream;
            currentChunks = audioChunks;
            currentId = id;
            currentText = text;

            document.querySelectorAll('.recording-indicator').forEach(el => el.style.display = 'none');
            const indicator = document.getElementById(`indicator_${id}`);
            if (indicator) {
                indicator.style.display = 'inline-block'; // Або 'block', залежно від бажаного центрування
            }

            mediaRecorder.ondataavailable = e => audioChunks.push(e.data);
            mediaRecorder.start();
        } catch (err) {
            console.error("Помилка доступу до мікрофону:", err);
            // Можна вивести повідомлення користувачу
            // alert("Не вдалося отримати доступ до мікрофону. Перевірте дозволи браузера.");
        }
    };

    window.stopRecording = () => {
        if (!currentRecorder) {
            console.log('ℹ️ Немає активного запису.');
            return;
        }
        currentRecorder.stop();
        if (currentStream) {
            currentStream.getTracks().forEach(t => t.stop());
        }

        currentRecorder.onstop = () => {
            const blob = new Blob(currentChunks, { type: 'audio/webm' });
            const formData = new FormData();
            const filename = currentText.toLowerCase()
                .replace(/[^\p{L}\p{N}\s]+/gu, '')
                .replace(/\s+/g, '_') + '.webm';

            formData.append('audio', blob, filename);

            const audioElement = document.getElementById(`audio_${currentId}`);
            if (audioElement) {
                audioElement.src = URL.createObjectURL(blob);
                audioElement.controls = true;
            }

            fetch('/upload-audio', { method: 'POST', body: formData })
                .then(res => {
                    if (res.ok) {
                        console.log(`✅ "${filename}" збережено!`);
                    } else {
                        console.log('❌ Помилка збереження');
                    }
                })
                .catch(err => console.error('❌ Помилка мережі під час збереження аудіо:', err));

            document.querySelectorAll('.recording-indicator').forEach(el => el.style.display = 'none');
            currentRecorder = null;
            currentStream = null;
            currentChunks = [];
            currentId = null;
            currentText = null;
        };
    };

    window.submitTest = () => {
        const notificationEl = document.getElementById('notification');
        if (!notificationEl) return;
        notificationEl.textContent = 'Відправлення тесту...';
        
        // Перевірка, чи answers існує і є валідним JSON перед парсингом
        const answersData = '{{ answers | default("null") | tojson | safe }}';
        let rawJson;
        try {
            rawJson = JSON.parse(answersData);
            if (rawJson === null && '{{ answers }}' !== 'None' && '{{ answers }}' !== '') { 
                // Якщо answers не None, але tojson дав null, можливо це порожній об'єкт/масив
                // В залежності від логіки сервера, може бути потрібно відправити порожній об'єкт {}
                console.warn("Answers variable might be empty or not structured as expected for JSON conversion.");
            }
        } catch (e) {
            console.error("Помилка парсингу JSON з answers:", e);
            notificationEl.textContent = '❌ Помилка даних тесту.';
            return;
        }


        fetch('/submit-test', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(rawJson) // rawJson може бути null, якщо answers не було
        })
        .then(resp => {
            notificationEl.textContent = resp.ok ? '✅ Тест надіслано!' : '❌ Помилка при надсиланні.';
        })
        .catch((err) => {
            console.error("Помилка fetch при надсиланні тесту:", err);
            notificationEl.textContent = '❌ Помилка при надсиланні (мережа).';
        });
    };

    // Кнопки запису/стоп запису
    document.querySelectorAll('.start-recording-button').forEach(btn =>
        btn.addEventListener('click', () =>
            startRecording(btn.dataset.id, btn.dataset.text)
        )
    );
    document.querySelectorAll('.stop-recording-button').forEach(btn =>
        btn.addEventListener('click', stopRecording)
    );

    // Взаємодія з вкладками
    document.querySelectorAll('.tab').forEach(tab => {
        tab.addEventListener('click', () => {
            document.querySelectorAll('.tab').forEach(el => el.classList.remove('active'));
            document.querySelectorAll('.tab-content').forEach(el => el.classList.remove('active'));
            
            tab.classList.add('active');
            const tabContentId = tab.dataset.tab;
            const tabContentElement = document.getElementById(tabContentId);
            if (tabContentElement) {
                tabContentElement.classList.add('active');
            }
        });
    });

    // Обробка вибору файлу
    const fileInput = document.getElementById('file-upload');
    const fileNameSpan = document.getElementById('file-name');
    if (fileInput && fileNameSpan) {
        fileInput.addEventListener('change', () => {
            fileNameSpan.textContent = fileInput.files.length ? fileInput.files[0].name : 'Файл не вибрано';
        });
    }

    // Налаштування
    // const settingsForm = document.getElementById('settings-form');
    // if (settingsForm) {
    //     settingsForm.addEventListener('submit', event => {
    //         event.preventDefault();
    //         const reactionDelayInput = document.getElementById('reaction-delay');
    //         const reactionDelay = reactionDelayInput ? reactionDelayInput.value : null;
    //         const mouseAnswersInput = document.getElementById('mouse-answers-enabled');
    //         const mouseAnswersEnabled = mouseAnswersInput ? mouseAnswersInput.checked : null;
    //         const highlightKeySelect = document.getElementById('replay-highlight-key');
    //         const replayHighlightKey = highlightKeySelect ? highlightKeySelect.value : null;
    //         const notificationElement = document.getElementById('settings-notification');

    //         if (!reactionDelay) {
    //             if (notificationElement) notificationElement.textContent = '❌ Не вдалося отримати значення затримки.';
    //             return;
    //         }
    //         if (mouseAnswersEnabled === null) {
    //             if (notificationElement) notificationElement.textContent = '❌ Не вдалося отримати стан перемикача миші.';
    //             return;
    //         }
    //         if (replayHighlightKey === null) {
    //             if (notificationElement) notificationElement.textContent = '❌ Не вдалося отримати параметр виділення повторів.';
    //             return;
    //         }

    //         fetch('/apply-settings', {
    //             method: 'POST',
    //             headers: { 'Content-Type': 'application/json' },
    //             body: JSON.stringify({
    //                 reaction_delay: reactionDelay,
    //                 mouse_answers_enabled: mouseAnswersEnabled,
    //                 replay_highlight_key: replayHighlightKey
    //             })
    //         })
    //         .then(res => {
    //             if (!res.ok) { // Перевірка статусу відповіді HTTP
    //                 throw new Error(`HTTP error! status: ${res.status}`);
    //             }
    //             return res.json();
    //         })
    //         .then(data => {
    //             if (notificationElement) {
    //                 notificationElement.textContent = data.status === 'ok' ? 'Налаштування збережено!' : 'Помилка: ' + (data.message || 'Невідома помилка');
    //             }
    //         })
    //         .catch(err => {
    //             console.error("Помилка при збереженні налаштувань:", err);
    //             if (notificationElement) {
    //                 notificationElement.textContent = `❌ Помилка при надсиланні (${err.message}).`;
    //             }
    //         });
    //     });
    // }

    // // Копіювання hardware ID
    // const hwEl = document.getElementById('hardware-id');
    // const confirmEl = document.getElementById('copy-confirmation');
    // if (hwEl && confirmEl) {
    //     hwEl.style.cursor = 'pointer';
    //     hwEl.addEventListener('click', () => {
    //         navigator.clipboard.writeText(hwEl.textContent || '')
    //             .then(() => {
    //                 confirmEl.style.display = 'inline';
    //                 setTimeout(() => confirmEl.style.display = 'none', 2000);
    //             })
    //             .catch(err => {
    //                 console.error('❌ Не вдалося скопіювати: ', err);
    //                 // alert('❌ Не вдалося скопіювати: ' + err); // Можливо, краще не використовувати alert
    //             });
    //     });
    // }
    const settingsForm = document.getElementById('settings-form');
    if (settingsForm) {
        const saveBtn = document.getElementById('save-settings-btn');
        const notificationElement = document.getElementById('settings-notification');

        // Робимо кнопку "Зберегти" активною при змінах
        settingsForm.addEventListener('input', () => {
            if (saveBtn) saveBtn.disabled = false;
        });

        settingsForm.addEventListener('submit', event => {
            event.preventDefault();
            const reactionDelayInput = document.getElementById('reaction-delay');
            const mouseAnswersInput = document.getElementById('mouse-answers-enabled');
            const highlightKeySelect = document.getElementById('replay-highlight-key');

            // Збираємо дані з форми
            const settingsData = {
                reaction_delay: reactionDelayInput ? reactionDelayInput.value : 15,
                mouse_answers_enabled: mouseAnswersInput ? mouseAnswersInput.checked : false,
                replay_highlight_key: highlightKeySelect ? highlightKeySelect.value : ""
            };

            if (notificationElement) notificationElement.textContent = 'Збереження...';

            fetch('/apply-settings', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(settingsData)
            })
            .then(res => res.json().then(data => ({ ok: res.ok, status: res.status, data })))
            .then(({ ok, status, data }) => {
                if (ok) {
                    notificationElement.textContent = '✅ Налаштування збережено!';
                    if (saveBtn) saveBtn.disabled = true; // Робимо кнопку неактивною
                } else {
                    notificationElement.textContent = `❌ Помилка: ${data.message || 'Невідома помилка'}`;
                }
                setTimeout(() => { if(notificationElement) notificationElement.textContent = ''; }, 3000);
            })
            .catch(err => {
                console.error("Помилка при збереженні налаштувань:", err);
                if (notificationElement) {
                    notificationElement.textContent = `❌ Помилка мережі.`;
                }
            });
        });
    }

    // --- НОВИЙ БЛОК ДЛЯ КОПІЮВАННЯ ID ---
    const copyBtn = document.getElementById('copy-hw-id-btn');
    const fullHwIdInput = document.getElementById('hardware-id-full');
    const confirmationSpan = document.getElementById('copy-confirmation');

    if (copyBtn && fullHwIdInput && confirmationSpan) {
        copyBtn.addEventListener('click', () => {
            const fullId = fullHwIdInput.value;
            navigator.clipboard.writeText(fullId).then(() => {
                confirmationSpan.style.display = 'inline';
                setTimeout(() => { confirmationSpan.style.display = 'none'; }, 2000);
            }).catch(err => {
                console.error('Не вдалося скопіювати ID:', err);
                alert('Помилка копіювання. Можливо, ваш браузер не підтримує цю функцію.');
            });
        });
    }
});



// Обробник для кнопки скачування TXT
document.getElementById('download-txt')?.addEventListener('click', () => {
    fetch('/download-test-txt')
        .then(res => {
            if (!res.ok) throw new Error('Network response was not ok');
            return res.blob();
        })
        .then(blob => {
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'test.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        })
        .catch(err => {
            console.error('Error downloading TXT:', err);
            alert('Помилка при скачуванні TXT файлу.');
        });
});

